<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'block_dash', language 'es_mx', version '4.3'.
 *
 * @package     block_dash
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['accordionfield1'] = 'Campo superior izquierdo';
$string['accordionfield1icon'] = 'Ícono de campo superior izquierdo';
$string['accordionfield2'] = 'Campo superior derecho';
$string['accordionfield2icon'] = 'Ícono de campo superior derecho';
$string['accordionfield3'] = 'Campo inferior izquierdo';
$string['accordionfield3icon'] = 'Ícono de campo inferior izquierdo';
$string['accordionfield4'] = 'Campo inferior derecho';
$string['accordionfield4icon'] = 'Ícono de campo inferior derecho';
$string['achieved'] = 'Logrado';
$string['activitybutton'] = 'Botón de actividad';
$string['activityprogress'] = 'Progreso (completado /total de actividades)';
$string['activityprogressbar'] = 'Barra del progreso (completado /total de actividades)';
$string['addcontent'] = 'Añadir contenido';
$string['addjointable'] = 'Adñadir {no} juntar tabla a formato';
$string['addnewfield'] = 'Añadir nuevo campo';
$string['addtocontacts'] = 'Añadir a contactos';
$string['alpha_asc'] = 'Ordenar alfabéticamente A-Z';
$string['alpha_desc'] = 'Ordenar alfabéticamente A-Z';
$string['always'] = 'Siempre';
$string['anothertrailpath'] = 'Otro ensayo';
$string['arrows'] = 'Mostrar flechas';
$string['arrows_help'] = 'Mostrar botones de flechas anterior/siguiente para navegación de páginas.';
$string['asc'] = 'ASC';
$string['attribute'] = 'Atributo';
$string['auto'] = 'Auto';
$string['autoplay'] = 'Autoreproducir';
$string['autoplaySpeed'] = 'Velocidad auto-reproducir (ms)';
$string['autoplaySpeed_help'] = 'Configurar la velocidad de la auto-reproducción en milisegundos.';
$string['autoplay_help'] = 'Auto-reproducir';
$string['availablefields'] = 'Campos disponibles';
$string['availablefields_help'] = 'Elegir todos los campos posibles que este origen de datos utilizará. El usuario podrá seleccionar cuales campos incluir para sus propios propósitos. Por ejemplo, si usted está mostrando información del usuario, intente incluir tantos campos del usuario como sea posible.';
$string['backgroundcolor'] = 'Color del fondo';
$string['backgroundgradient'] = 'Gradiente del fondo';
$string['backgroundgradient_help'] = 'Generar un gradiente: <a href="https://cssgradient.io/" target="_blank">cssgradient.io</a>. Pegue la propiedad del fondo  (linear-gradient)';
$string['backgroundimage'] = 'Imagen del fondo';
$string['backgroundimage_help'] = 'Cubrir todo el fondo del bloque con esta imagen';
$string['backgroundimagefield'] = 'Imagen del fondo';
$string['backgroundimageurl'] = 'URL de la imagen del fondo';
$string['backgroundposition'] = 'Posición del fondo';
$string['backgroundposition_help'] = 'La imagen del fondo se enfocará enla posición dada';
$string['backgroundsize'] = 'Tamaño del fondo';
$string['backgroundsize_help'] = 'La imagen del fondo se mostrará en el tamaño';
$string['badgecolorfield'] = 'Campo del color de insignia';
$string['badgecolorfield_help'] = 'Escoger un campo que regrese colores a ser usados para insignias de elemento línea del tiempo.';
$string['badges'] = 'Insignias';
$string['badgestitle'] = 'Insignias';
$string['between'] = 'Entre';
$string['blockcontext'] = 'Bloque';
$string['blocksnotfound'] = 'el Tablero actual no contiene ningún bloque.';
$string['blocktitle'] = 'Título del bloque';
$string['blocktitle_help'] = 'Título mostrado en encabezado del bloque. Escriba un título breve y descriptivo para que el bloque lo muestre al usuario.';
$string['blockwidth'] = 'Ancho del bloque';
$string['bodyfield'] = 'Campo del cuerpo (body)';
$string['bootstrapversion'] = 'Versión Bootstrap del tema';
$string['bootstrapversion_desc'] = 'Elegir la versión de Bootstrap que su tema soporta. Moodle típicamente es 4, y Totara es 3.';
$string['border'] = 'Borde';
$string['border_help'] = 'Valor de propiedad borde CSS.';
$string['border_option'] = 'Mostrar borde';
$string['border_option_help'] = 'Usted puede añadir  el borde del bloque Dash.';
$string['bordervalue'] = 'Valor del Borde';
$string['buildown'] = 'Construir el suyo propio';
$string['buildown_help'] = 'Los datasourses (orígenes de datos) son altamente configurables. Usted puede usar los datasorces en varios propósitos. Las características para , filtrar, Ordenar, paginación están soportadas.';
$string['buynow'] = 'Comprar ahora';
$string['campaign'] = 'Campaña';
$string['categories'] = 'Categorías';
$string['categories_help'] = 'Datasources de categorías enlistan las categorías sisponibles.';
$string['category'] = 'Nombre de categoría';
$string['categorycoursecount'] = 'Número de cursos';
$string['categoryimage'] = 'Imagen de categoría';
$string['categoryimagelink'] = 'Enlace a categoría';
$string['categoryimageurl'] = 'URL de imagen de categoría';
$string['categoryimgcategory'] = 'Imagen para categoría {$a->category}';
$string['categoryimgdesc'] = 'Añadir imágenes para las categorías';
$string['categoryimgfallback'] = 'Imagen \'plan B\' de categoría';
$string['categoryimgfallbackdesc'] = 'Subir la imagen con el \'plan B\' de categorías. Si son creadas nuevas categorías, la imagen del \'plan B\' será mostrada hasta que una nueva imagen sea añadida para la categoría.';
$string['categoryimgheading'] = 'Imagen de categoría';
$string['categoryimgheadingsub'] = 'Imágenes de categorías';
$string['categoryurl'] = 'URL de categoría';
$string['centerMode'] = 'Modo centrado';
$string['centerMode_help'] = 'Habilita vista centrada con páginas parciales anterior/siguiente. Use con páginas de números nones para mostrar número.';
$string['centerPadding'] = 'Relleno centrado (px)';
$string['centerPadding_help'] = 'Relleno lateral cuando en modo centrado (px).';
$string['centerbottom'] = 'Centrar Fondo';
$string['centercenter'] = 'Centrar Centro';
$string['centertop'] = 'Centrar Superior';
$string['certificatecodelinked'] = 'Código enlazado';
$string['choosedatasource'] = 'Elegir fuente de datos';
$string['choosefeature'] = 'Elegir Característica';
$string['choosefilter'] = 'Elegir filtros';
$string['chooseskill'] = 'Elegir habilidad';
$string['circlepath'] = 'Círculo';
$string['cohorts'] = 'Cohortes';
$string['columns'] = 'Columnas';
$string['columns_help'] = 'El número de columnas a mostrar por fila en la rejilla.';
$string['compentenciesnotfound'] = 'Competencia no encontrada';
$string['competencyappearance'] = 'Apariencias de competencia';
$string['competencycolor'] = 'Color de competencia';
$string['competencyframework'] = 'Estructura de competencia';
$string['competencyheading'] = 'Configurar apariencia de competencia';
$string['competencyimage'] = 'Imagen de competencia';
$string['completedactivities'] = 'Actividades completadas';
$string['completedcourse'] = 'Curso completado';
$string['completedlearningpath'] = 'Ruta de apredizaje completa. ¡Buen trabajo!';
$string['completion:completed'] = 'Completado';
$string['completion:inprogress'] = 'En progreso';
$string['completion:notstarted'] = 'Aun no iniciado';
$string['conditionaddfields'] = 'Añadir {no} condición(es)';
$string['conditionsection'] = 'Configuración de condición';
$string['conditionstatichdr'] = 'Condición #0';
$string['conditionvalue'] = 'Valor';
$string['conditionvalue_help'] = 'Valor de condición - Ingrese el valor específico contra el cual será comprobada la condición. Este valor es crucial para determinar cuando la condición es cumplida o satisfecha.
Ingrese el valor con coma (,) para condiciones IN';
$string['confirmleavegroup'] = '¿Realmente quiere dejar el grupo {$a} ?';
$string['contacts'] = 'Contactos';
$string['contain'] = 'Contiene';
$string['contentdisplay'] = 'Mostrar';
$string['contentdisplayallpage'] = 'Todas las páginas';
$string['contentdisplaysection'] = 'Páginas de sección';
$string['contenteditor'] = 'Contenido';
$string['contentlayout'] = 'Arreglo del contenido';
$string['contentmodaltitle'] = 'Actualizar el contenido de Dash';
$string['contentsectiondisplay'] = 'Mostrar secciones';
$string['contentsections'] = 'Secciones a mostrar';
$string['contextcategory'] = 'Categoría';
$string['contextcourse'] = 'Curso';
$string['contextid'] = 'Contexto';
$string['contextid_help'] = 'El contexto para este tablero. elija un curso específico si usted planea limitar resultados de datos (Ejemplo: filtro "Usuario actual). En caso contrario elegir Sistema para propósitos generales.';
$string['contextlevel'] = 'Nivel del contexto';
$string['contextlinked'] = 'Contexto enlazado';
$string['contextmissing'] = 'Contexto faltante';
$string['contextname'] = 'Nombre del contexto';
$string['contextsettings'] = 'Configuraciones del contexto';
$string['contextsystem'] = 'Sistema';
$string['contexttype'] = 'Tipo de contexto';
$string['contexturl'] = 'URL del contexto';
$string['copy'] = 'Copia';
$string['coredashboard'] = 'Tablero  principal';
$string['course_enrol_role'] = 'Rol para inscripción usando el widget de inscripción';
$string['course_enrolments:abovecourseform'] = 'Arriba de los cursos';
$string['course_enrolments:belowcourseform'] = 'Debajo de los cursos';
$string['course_enrolments:disabled'] = 'Deshabilitado';
$string['course_enrolments:displayaddcourse'] = 'Mostrar formato para añadir curso';
$string['course_enrolments:expandable'] = 'Expandible';
$string['course_enrolments:progress'] = 'Mostrar progreso';
$string['course_enrols:viewotherprofiledash'] = 'Ver el bloque Dash del perfil de otros';
$string['course_enrols:viewprofiledash'] = 'Ver el bloque Dash del perfil';
$string['coursebutton'] = 'Botón de curso';
$string['coursecatcontext'] = 'Categoría del Curso';
$string['coursecategories'] = 'Categoría de curso';
$string['coursecontent'] = 'Contenido del curso';
$string['coursecontext'] = 'Curso';
$string['coursedata:past'] = 'Pasado';
$string['coursedate:future'] = 'Futuro';
$string['coursedate:present'] = 'Presente';
$string['coursedates'] = 'Fechas del curso';
$string['coursefullname'] = 'Nombre completo del curso';
$string['courseidnumber'] = 'IDnumber del curso';
$string['courseimage'] = 'Imagen predeterminada del curso';
$string['courseimagedesc'] = 'Subir imagen reemplazable a mostrar como imagen del curso para imagen vacía del curso.';
$string['courseimagelink'] = 'Enlace a imagen del curso';
$string['courseinformation'] = 'Información del curso';
$string['courseoverviewfilesurl'] = 'URL de imagen del curso';
$string['courseredirecturl'] = 'URL redireccionar curso';
$string['courseredirecturldesc'] = 'Ingrese la URL para redirigir a los usuarios desde la página del índice del curso.';
$string['courseshopurl'] = 'URL tienda del curso';
$string['courseshortname'] = 'Nombre corto del curso';
$string['coursestafftitle'] = 'Staff del curso';
$string['coursestartdate'] = 'Fecha de inicio del curso';
$string['coursestartdate_asc'] = 'Por fecha de inicio del curso (más nueva primero)';
$string['coursestartdate_desc'] = 'Por fecha de inicio del curso (más antigua primero)';
$string['coursesummary'] = 'Resumen del curso';
$string['courseurl'] = 'URL del curso';
$string['cover'] = 'Cubierta';
$string['createcustomdatasource'] = 'Crear origen de datos personalizados';
$string['createcustomlayout'] = 'Crear diseño personalizado';
$string['createdashboard'] = 'Crear tablero';
$string['createddate'] = 'Fecha de creación';
$string['createlayout'] = 'Crear diseño personalizado';
$string['cssclass'] = 'Clases CSS';
$string['cssclass_help'] = 'Usar una clase CSS personalizada para aplicar clases múltiples.';
$string['currentcategory'] = 'Categoría Actual';
$string['currentcourse'] = 'Curso actual';
$string['currentcoursecontext'] = 'Contexto curso actual';
$string['currentcoursegroups'] = 'Grupos de curso actual';
$string['currentcourseskills'] = 'Habilidades de curso actual';
$string['currentlevel'] = 'Nivel actual';
$string['custom'] = 'Personalizado';
$string['customcondition'] = 'Crear consulta de condición';
$string['customdatasource'] = 'Origen de datos personalizados';
$string['customdatasourcecreated'] = 'Origen de datos <b>{$a->name}</b> creado exitosamente.';
$string['customdatasourcedeleted'] = 'Eliminar origen de datos personalizados';
$string['customdatasourceedited'] = 'Origen de datos <b>{$a->name}</b> editado exitosamente.';
$string['customdatasources'] = 'Orígenes de datos personalizados';
$string['customfeaturetype'] = 'Tipo de característica personalizada';
$string['customfield'] = '{$a->name}';
$string['customfields'] = 'Campos personalizados';
$string['customlayoutcreated'] = 'Diseño personalizado <b>{$a->name}</b> creado exitosamente.';
$string['customlayoutdeleted'] = 'Diseño personalizado <b>{$a->name}</b> eliminado exitosamente.';
$string['customlayoutedited'] = 'Diseño personalizado <b>{$a->name}</b> editado exitosamente.';
$string['customsqlfield'] = 'campo SQL';
$string['customsqlselect'] = 'seleccionar SQL';
$string['customurl'] = 'URL personalizada';
$string['customurltext'] = 'Texto de URL personalizada';
$string['dash:addinstance'] = 'Añadir un nuevo bloque Dash';
$string['dash:managecoursecatedashboards'] = 'Gestionar orígenes de datos de categoría de curso';
$string['dash:managedatasource'] = 'Gestionar Datasources';
$string['dash:managewidget'] = 'Gestionar Widgets';
$string['dash:myaddinstance'] = 'Añadir un nuevo bloque Dash al Tablero';
$string['dash:mygroups_addusers'] = 'Añadir usuarios dentro de grupos';
$string['dash:mygroups_creategroup'] = 'Crear grupos en cursos inscritos';
$string['dash:mygroups_leavegroup'] = 'Dejar de grupos';
$string['dash:mygroups_view'] = 'Ver mis propios grupos';
$string['dash:mygroups_viewmembers'] = 'Ver miembros en grupos asignados';
$string['dashaddoncontentdesc'] = 'Elegir entre los diseños siguientes';
$string['dashaddonpluginname'] = 'Nombre de';
$string['dashbgimg'] = 'Imagen de fondo';
$string['dashbgimg_help'] = 'La imagen de fondo usada como fondo para el Tablero.';
$string['dashboard'] = 'Tablero';
$string['dashboardcreated'] = 'Tablero <b>{$a->name}</b> creado exitosamente';
$string['dashboarddeleted'] = 'Tablero <b>{$a->name}</b> eliminado exitosamente';
$string['dashboardduplicated'] = 'Tablero duplicado exitosamente';
$string['dashboardedited'] = 'Tablero <b>{$a->name}</b> editado exitosamente';
$string['dashboardlink'] = 'Enlace al Tablero';
$string['dashboards'] = 'Tableros';
$string['dashicon'] = 'Íconos';
$string['dashicon_help'] = 'Este ícono solamente se muestra en el origen de datos de Tableros';
$string['dashthumbnailimg'] = 'Imagen miniatura';
$string['dashthumbnailimg_help'] = 'La imagen miniatura solamente se muestra en origen de datos de Tableros';
$string['dashthumbnailimgurl'] = 'URL de imagen miniatura';
$string['databaseerror'] = 'Error de base de datos. El contenido no puede ser mostrado.';
$string['datasource'] = 'Origen de datos';
$string['datasource:competency_widget'] = 'Widget de gráfica de habilidad';
$string['datasource:completion_widget'] = 'Widget de finalizaciones de curso';
$string['datasource:completions_data_source'] = 'Finalizaciones de curso';
$string['datasource:completions_data_source_help'] = 'Lista de usuarios con cursos completados.';
$string['datasource:courses_data_source'] = 'Cursos';
$string['datasource:courses_data_source_help'] = 'Lista de cursos disponibles para el usuario actual.';
$string['datasource:dashboard_data_source'] = 'Tableros';
$string['datasource:dashboard_data_source_help'] = 'Lista de Tablero';
$string['datasource:enrolments_widget'] = 'Widget de Inscripcines';
$string['datasource:logstore_data_source'] = 'Bitácoras del sitio';
$string['datasource:logstore_data_source_help'] = 'Datasource de bitácoras del sitio';
$string['datasource:roleassignments_data_source'] = 'Asignaciones de rol';
$string['datasourcedesc'] = 'Añadir contenido dinámico con orígenes de datos y diseños';
$string['datasourcemissing'] = 'Falta origen de datos';
$string['datasourcename'] = 'Nombre de origen de datos';
$string['datasources'] = 'Datasources';
$string['datecompleted'] = 'Fecha completado';
$string['daysuntilend'] = 'Días restantes hasta fecha final';
$string['daysuntilstart'] = 'Días faltantes hasta fecha inicial';
$string['defaultexportdata'] = 'Exportar datos Dash';
$string['defaultexportdata_help'] = 'Esta configuración permite habilitar/deshabilitar los datos de exportación de datasource Dash.';
$string['defaultsortdirection'] = 'Dirección de ordenamiento';
$string['defaultsortfield'] = 'Ordenar por';
$string['defaultsortfield_help'] = 'Ordenar resultados de base de datos por este campo. Si el diseño soporta ordenamiento de usuario, esto será lo predeterminado.';
$string['delete'] = 'Eliminar';
$string['deletecondition'] = 'Eliminar esta condición';
$string['deleteconfirm'] = '¿Está seguro de querer eliminar el Tablero <b>{$a->name}</b>?';
$string['deleteconfirmcustomdatasource'] = '¿Está seguro de querer eliminar el  <b>{$a->name}</b> orígen de datos personalizados?';
$string['deleteconfirmcustomlayout'] = '¿Está seguro de querer eliminar el diseño personalizado  <b>{$a->name}</b> ?';
$string['deletecustomdatasource'] = 'Eliminar orígenes de datos personalizados';
$string['deletecustomlayout'] = 'Eliminar diseño personalizado';
$string['deletedashboard'] = 'Eliminar tablero';
$string['deletefield'] = 'Eliminar este campo';
$string['deletejoin'] = 'Eliminar esta tabla de unión';
$string['desc'] = 'DESC';
$string['description'] = 'Descripción';
$string['designercustombgposition'] = 'Posición Fondo Personalizada';
$string['designercustombgsize'] = 'Tamaño Fondo Personalizado';
$string['desktop_learningpath'] = 'Ruta de Aprendizaje para Escritorio';
$string['desktop_learningpath_desc'] = '';
$string['details_area'] = 'Área de detalles';
$string['details_area_help'] = 'Elegir cómo quiere mostrar el área de detalles.';
$string['details_area_locations'] = 'Área de detalles de localizaciones';
$string['details_area_locations_help'] = 'Escriba los detalles para cada sitio que usted quiera mostrar en el área de detalles.';
$string['details_area_size'] = 'Área de detalles de tamaño';
$string['details_area_size_help'] = 'Elegir cómo desea el tamaño del área de detalles.';
$string['details_bg_color'] = 'Color del fondo de Detalles';
$string['details_body_1'] = 'Detalles Cuerpo 1';
$string['details_body_2'] = 'Detalles Cuerpo 2';
$string['details_body_3'] = 'Detalles Cuerpo 3';
$string['details_footer_left'] = 'Detalles Pie de página izquierda';
$string['details_footer_right'] = 'Detalles Pie de página derecha';
$string['details_text_color'] = 'Detalles color del texto';
$string['details_title'] = 'Detalles Título';
$string['developerfield'] = '{$a}';
$string['developerfieldid'] = 'id';
$string['disableall'] = 'Deshabilitar toda la salida de Dash';
$string['disableall_help'] = 'Advertencia: Para propósitos de depuración o diagnóstico de páginas rotas.';
$string['disableallmessage'] = 'Salida Dash deshabilitada. Compruebe las configuraciones de Dash.';
$string['disabled'] = 'Deshabilitado';
$string['donut'] = 'Dona';
$string['dot'] = 'Punto';
$string['dots'] = 'Mostrar puntos';
$string['dots_help'] = 'Mostrar indicadores de puntos para navegación por páginas';
$string['downloadcertificate'] = 'Descargar certificado';
$string['downloadcsv'] = 'Descargar en formato CSV';
$string['draggable'] = 'Arrastrable';
$string['draggable_help'] = 'Permitir arrastrar y mover páginas.';
$string['dragitem'] = 'Arrastrar elemento';
$string['duedate'] = 'Fecha esperada';
$string['duplicatedashboard'] = 'Duplicar Tablero';
$string['edit'] = 'Editar';
$string['editcontent'] = 'Editar contenido';
$string['editcustomdatasource'] = 'Editar origen de datos';
$string['editcustomlayout'] = 'Editar diseño personalizado';
$string['editdashboard'] = 'Editar tablero';
$string['editpreferences'] = 'Editar preferencias';
$string['editthisblock'] = 'Editar las configuraciones de este bloque para terminar la configuración.';
$string['edituserenrolment'] = 'Editar la inscripción de {$a}\'';
$string['emptystateheading'] = 'Estado vacío';
$string['enableconditions'] = 'Habilitar condiciones';
$string['enabledconditions'] = 'Limitar datos a';
$string['enabledfields'] = 'Campos habilitados';
$string['enabledfilters'] = 'Filtros habilitados';
$string['enabledownload'] = 'Exportar datos';
$string['enabledownload_help'] = 'Esta configuración habilita que los usuarios descarguen los datos tanto en formatos CSV y XLS.';
$string['enablejoins'] = 'Habilitar uniones';
$string['enroldate_asc'] = 'Ordenar por fecha de inscripción (más antiguos primero)';
$string['enroldate_desc'] = 'Ordenar por fecha de inscripción (más nuevos primero)';
$string['enroldetails'] = 'Detalles de inscripción';
$string['enroled'] = 'Inscrito';
$string['enrollment'] = 'Inscripción';
$string['enrollment_options'] = 'Opciones de inscripción';
$string['enrollmentmethod'] = 'Método de inscripción';
$string['enrollmentmethodstatus'] = 'Estado del método de inscripción';
$string['enrollmentoptions'] = 'Métodos de inscripción';
$string['enrollmentoptions:cost'] = 'Desde {$a->currency} {$a->cost}';
$string['enrollmentoptions:credits'] = '{$a} créditos';
$string['enrollmentoptions:free'] = 'Gratuito';
$string['enrollmentoptions:fromcredits'] = 'Desde {$a} créditos';
$string['enrollmentoptions:seeoptions'] = 'Ver opciones';
$string['enrollments'] = 'Inscripciones';
$string['enrollmentself'] = 'Auto inscripciones';
$string['enrollmentsnotself'] = 'No-auto inscripciones';
$string['enrollmentstatus'] = 'Estado de inscripción';
$string['enrollmenttimeend'] = 'Fecha de término de inscripción';
$string['enrollmenttimestart'] = 'Fecha de inicio de inscripción';
$string['enrolmentmethod'] = 'Método de inscripción';
$string['enrolmentoptions'] = 'Opciones de inscripción';
$string['enrolnow'] = 'Inscribir ahora mismo';
$string['enterclasses'] = 'Ingresar clases';
$string['even:icon'] = 'Ícono del evento';
$string['event'] = 'Evento';
$string['event:color'] = 'Color del evento';
$string['event:contextevent'] = 'Contexto del evento';
$string['event:contextlinked'] = 'Contexto del evento (enlazado)';
$string['event:description'] = 'Descripción';
$string['event:duration'] = 'Duración del evento';
$string['event:durationinminutes'] = 'Duración del evento en minutos';
$string['event:enddate'] = 'Fecha de término';
$string['event:endtime'] = 'Hora de término';
$string['event:filterdate'] = 'Fecha';
$string['event:filterday'] = 'Día de la semana';
$string['event:gotoactivity'] = 'Ir a actividad';
$string['event:image'] = 'Imagen del evento';
$string['event:imagelinked'] = 'Imagen del evento (enlazada)';
$string['event:imageurl'] = 'URL de Imagen del evento';
$string['event:location'] = 'Ubicación';
$string['event:repeated'] = 'Evento repetido';
$string['event:startdate'] = 'Fecha de inicio';
$string['event:starttime'] = 'Hora de inicio';
$string['event:status'] = 'Estado';
$string['event:title'] = 'Título del evento';
$string['event:type'] = 'Tipo de evento';
$string['event:typecategory'] = 'Categoría del curso';
$string['event:typecourse'] = 'Curso';
$string['event:typefilter'] = 'Filtro de tipo de evento';
$string['event:typegroup'] = 'Grupo';
$string['event:typeother'] = 'Otro';
$string['event:typesite'] = 'Sitio';
$string['event:typeuser'] = 'Usuario';
$string['event_desc_core_event_user_enrolment_created'] = '{$a->relateduserfullname} fue inscrito en <a href="{$a->eventurl}" title="Ver {$a->contextname}">{$a->contextname}</a>';
$string['event_desc_generic'] = '{$a->userfullname} {$a->action} <a href="{$a->eventurl}" title="Ver {$a->contextname}">{$a->contextname}</a>';
$string['eventactivity:both'] = 'Actividades incompletas y completas';
$string['eventactivity:incomplete'] = 'Solo actividades incompletas';
$string['eventactivitycompletion'] = 'Asociado a una actividad';
$string['eventbutton'] = 'Botón del evento';
$string['eventclass'] = 'Clase del evento';
$string['eventcolor'] = 'Color del evento';
$string['eventcontext'] = 'Contexto del evento';
$string['eventdescription'] = 'Descripción del evento';
$string['eventicon'] = 'Ícono del evento';
$string['eventlink'] = 'Enlace del evento';
$string['events'] = 'Eventos';
$string['eventstatus'] = 'Estado del evento';
$string['eventtime'] = 'Hora del evento';
$string['eventurl'] = 'URL del evento';
$string['extracontent'] = 'Contenido extra';
$string['extralargeimage'] = 'Imagen extra grande';
$string['fade'] = 'Desvanecer';
$string['fade_help'] = 'Habilitar efecto de desvanecer en transición de páginas.';
$string['failed'] = 'Reprobado';
$string['field'] = 'Campo';
$string['field:completedactivitiesinweek'] = 'Actividades completadas esta semana';
$string['field:completedcourses'] = 'Cursos completados';
$string['field:completedcoursesinweek'] = 'Cursos completados esta semana';
$string['field:courseimgsize'] = 'Tamaño de imagen del curso';
$string['field:courseimgsize_help'] = 'Punto — punto de 20x20 px, sin la imagen del curso. <br>
Imagen minúscula— 35x35px.<br>
Imagen pequeña — 50x50px.<br>
Imagen mediana — 75x75px.<br>
Imagen grande — 100x100px.<br>
Imagen extra grande — 150x150px.';
$string['field:coursesinprogress'] = 'Cursos en progreso';
$string['field:currentcoursescount'] = 'Cursos actuales';
$string['field:detailsarea'] = 'Área de detalles';
$string['field:detailsarea_help'] = 'Si fuera cierta, muestra un área de detalles como modal al hacer clic en el curso';
$string['field:earnedandtotalpoints'] = 'Puntos de habilidad ganados/totales';
$string['field:earnedskillpoints'] = 'Puntos de habilidad ganados';
$string['field:enrolledprogress'] = 'Cursos completados/totales';
$string['field:finishelement'] = 'Elemento terminar';
$string['field:finishelement_help'] = 'Si fuera cierto, añade el elemento terminar al Fin de la ruta';
$string['field:fullname'] = 'Mostrar nombre completo del usuario';
$string['field:futurecoursescount'] = 'Cursos futuros';
$string['field:infoarea'] = 'Área de información';
$string['field:infoarea_help'] = 'Si fuera cierto, añade el área de información';
$string['field:kpi'] = 'Indicadores Claves del desempeño {$a}';
$string['field:learningpathdesktop'] = 'Ruta para Escritorio';
$string['field:learningpathmobile'] = 'Ruta para Mobile';
$string['field:learningpathtablet'] = 'Ruta para Tableta';
$string['field:limit'] = 'Límite';
$string['field:limit_help'] = 'Límite';
$string['field:loginsthisweek'] = 'Ingresos esta semana';
$string['field:loginstreak'] = 'Racha de ingresos';
$string['field:numberofcontactreq'] = 'Número de solicitudes de contacto';
$string['field:numberofdueactivities'] = 'Número de actividades pendientes';
$string['field:numberofoverdueactivities'] = 'Número de actividades retrasadas';
$string['field:numberofunreadmsg'] = 'Número de mensajes sin leer';
$string['field:onlineuserscount'] = 'Número de usuarios actualmente en línea';
$string['field:orderby'] = 'Ordenar por';
$string['field:orderby_help'] = 'Ordenar por';
$string['field:orderdirection'] = 'Dirección de ordenamiento';
$string['field:orderdirection_help'] = 'Dirección de ordenamiento';
$string['field:pastcoursescount'] = 'Cursos pasados';
$string['field:profileimage'] = 'Mostrar imagen del perfil del usuario';
$string['field:profileuserinfo'] = 'Información del perfil del usuario {$a}';
$string['field:sincelogindays'] = 'Número de días desde el último ingreso';
$string['field:startelement'] = 'Elemento iniciar';
$string['field:startelement_help'] = 'Si fuera cierto, añade el elemento iniciar al principio de la ruta';
$string['field:teammemberscount'] = 'Número de miembros del equipo';
$string['fieldalert'] = 'El diseño elegido no puede ser personalizado';
$string['fieldalllevels'] = 'Mostrar todos los niveles';
$string['fieldattributeshdr'] = 'Transformar formato de datos de campo';
$string['fieldcurrentlevel'] = 'Mostrar nivel actual';
$string['fieldcustomdata'] = 'Valor de formato adicional';
$string['fieldcustomdata_help'] = 'Ingresar los datos adicionales relacionados con el atributo seleccionado
<b>Por ejemplo: </b>
1. Para el atributo enlace, ingresar el enlace y usar los valores del campo como parámetros <br>
2. Para el atributo porcentaje, usar el valor outof (de un total de). Para las calificaciones usar 10 porque en otro caso se usa 100';
$string['fieldname'] = 'Nombre del campo';
$string['fieldnotfound'] = 'Campo no encontrado.';
$string['fields'] = 'Campos';
$string['fieldselect'] = 'Seleccionar campo SQL';
$string['fieldssection'] = 'Configuración de campos';
$string['fieldstatichdr'] = 'Campo #0';
$string['fieldtransformdata'] = 'Transformar el formato';
$string['fieldtransformdata_help'] = 'Transformar el formato del valor cuando es mostrado en la tabla';
$string['filter:friday'] = 'Viernes';
$string['filter:monday'] = 'Lunes';
$string['filter:saturday'] = 'Sábado';
$string['filter:sunday'] = 'Domingo';
$string['filter:thismonth'] = 'Este mes';
$string['filter:thisweek'] = 'Esta semana';
$string['filter:thursday'] = 'Jueves';
$string['filter:today'] = 'Hoy';
$string['filter:tuesday'] = 'Martes';
$string['filter:upcoming'] = 'Próximo';
$string['filter:wednesday'] = 'Miércoles';
$string['fit_content'] = 'Ajustar contenido';
$string['fit_content_help'] = 'Hacer la altura del área de detalles la misma que la de la tarjeta, y dejar que el ancho sea determinado por el contenido.';
$string['fontcolor'] = 'Color del font (tipo de letra)';
$string['fontcolor_help'] = 'Propiedad CSS del color del font (por ejemplo #ffffff, rgb(255, 255, 255), etc)';
$string['footercontent'] = 'Contenido del pie de página';
$string['footercontent_help'] = 'Contenido mostrado en el pie de página del bloque.';
$string['footerfield'] = 'Campo del pie de página';
$string['footerrightfield'] = 'Campo del pie de página (derecho)';
$string['fullnamelinked'] = 'Nombrecompleto enlazado';
$string['generalsettings'] = 'Configuraciones generales';
$string['generateattributes'] = 'Generar atributos de campo';
$string['generatefields'] = 'Generar campos';
$string['gotoevent'] = 'Ir al evento';
$string['gridsizeoptions'] = 'Ancho\\nAlto\\nCuadrado';
$string['groupby'] = 'Agrupar por';
$string['grouplabel'] = 'Etiqueta del grupo';
$string['headercontent'] = 'Contenido del encabezado';
$string['headercontent_help'] = 'Contenido mostrado en el encabezado del bloque.';
$string['headerfooter'] = 'Encabezado y Pie de página';
$string['headingfield'] = 'Campo del encabezado';
$string['hidden'] = 'Oculto';
$string['hidecompletedskills'] = 'Ocultar habilidades completadas';
$string['hidecoursecategory'] = 'No mostrar categoría/índice del curso';
$string['hidecoursecategorydesc'] = 'Cuando un usuario intenta acceder a la URL /course/index.php, ellos serán automáticamente re-dirigidos a la página inicial del sitio, a menos que aquí esté especificada una URL personalizada debajo
Si una URL está especificada, el usuario será redirigido a esa URL';
$string['hideindividualskills'] = 'Ocultar habilidades individuales';
$string['hidemycourses'] = 'Ocultar mis cursos inscritos';
$string['hideshow'] = 'Ocultar/Mostrar';
$string['hidetable'] = 'Ocultar la tabla de contenidos.';
$string['hidetable_help'] = 'Habilitar esta opción le permite a los usuarios ocultar el contenido de la tabla en instancia Dash. Solamente permanecerán visibles los bloques del encabezado y el pie de página.';
$string['hidewhenempty'] = 'Ocultar cuando esté vacío';
$string['hidewhenempty_desc'] = 'Ocultar el bloque Dash cuando está vacío.';
$string['higherthan'] = 'Mayor que';
$string['iconfield'] = 'Campo del ícono';
$string['imageoverlayfield'] = 'Campo del sobrepuesto de imagen';
$string['imageoverlayfield_help'] = 'Contenido a mostrar sobre imagen con fondo sólido.';
$string['imageurlfield'] = 'Campo de URL de imagen';
$string['imageurlfield_help'] = 'Elegir un campo de URL de imagen que será usada en cada tarjeta en la rejilla.';
$string['includedblocks'] = 'Bloques incluidos';
$string['includesubcategories'] = 'Incluir subcategorías';
$string['includesubcategories_help'] = 'Si se activa, las subcategorías de las categorías elegidas también serán incluidas en los resultados.';
$string['incomplete'] = 'Incompleto';
$string['infinite'] = 'Bucle infinito';
$string['infinite_help'] = 'Habilitar deslizamiento de bucle infinito';
$string['initial'] = 'Inicial';
$string['invalididnumberunique'] = 'Número ID ya existe.';
$string['invalidoperator'] = 'Operador inválido {$a->operator}.';
$string['invalidshortname'] = 'Nombre corto inválido. Solamente debe contener letras a-zA-Z o guiónes (-).';
$string['invalidshortnametoolong'] = 'Nombre corto inválido. Debe ser de 16 caracteres o menos.';
$string['invalidshortnameunique'] = 'Este nombre corto ya está usado por otro tablero.';
$string['invalidwhereclause'] = 'Inválido donde cláusula. Sin valores proporcionados.';
$string['label'] = 'Etiqueta';
$string['label:completedactivitiesinweek'] = 'Actividades completadas esta semana';
$string['label:completedcourses'] = 'Cursos completados';
$string['label:completedcoursesinweek'] = 'Cursos completados esta semana';
$string['label:coursesinprogress'] = 'Cursos en progreso';
$string['label:currentcoursescount'] = 'Cursos actuales';
$string['label:earnedandtotalpoints'] = 'Puntos ganados/totales';
$string['label:earnedskillpoints'] = 'Puntos colectados';
$string['label:enrolledprogress'] = 'Cursos completados';
$string['label:futurecoursescount'] = 'Cursos futuros';
$string['label:loginsthisweek'] = 'Ingresos esta semana';
$string['label:loginstreak'] = 'Racha de día';
$string['label:numberofcontactreq'] = 'Solicitudes de contacto';
$string['label:numberofdueactivities'] = 'Actividades pendientes';
$string['label:numberofoverdueactivities'] = 'Actividades retrasadas';
$string['label:numberofunreadmsg'] = 'Mensajes sin leer';
$string['label:onlineuserscount'] = 'Usuarios actualmente en línea';
$string['label:pastcoursescount'] = 'Cursos pasados';
$string['label:sincelogindays'] = 'Días desde el último ingreso';
$string['label:teammemberscount'] = 'Miembros del equipo';
$string['largeimage'] = 'Imagen grande';
$string['layout'] = 'Diseño';
$string['layoutaccordion'] = 'Diseño de acordeón (con tablas)';
$string['layoutaccordion2'] = 'Diseño de acordeón';
$string['layoutcards'] = 'Diseño de rejilla';
$string['layoutdoesnotsupportfiltering'] = 'El diseño elegido no soporta filtrado';
$string['layoutdoubleequal'] = 'Doble igual';
$string['layoutdoubleleft'] = 'Doble (1/3, 2/3)';
$string['layoutdoubleright'] = 'Doble (2/3, 1/3)';
$string['layoutfull'] = 'Diseño completo';
$string['layoutgrid'] = 'Diseño de tabla';
$string['layoutmode'] = 'Modo de diseño';
$string['layoutmode_help'] = 'Seleccionar cuál modo aparece en el widget';
$string['layoutonestat'] = 'Diseño de una figura + etiqueta';
$string['layouttimeline'] = 'Diseño de línea de tiempo';
$string['layouttriple'] = 'Triple igual';
$string['layouttwostat'] = 'Diseño de una figura /otra figura';
$string['layouttype'] = 'Tipo de diseño';
$string['leanringpath_infocontent'] = 'Usted ha completado <b>{$a->completed}</b> de un total de <b> {$a->total} </b> cursos. El curso siguiente en esta ruta de aprendizaje es: <b> {$a->nextcourse}</b>';
$string['learningpath:infoarea'] = 'Contenido del área de información';
$string['learningpath:path'] = 'Ruta';
$string['learningpathfinish'] = 'Término';
$string['learningpathstart'] = 'Inicio';
$string['leftbottom'] = 'Izquierda Fondo';
$string['leftcenter'] = 'Izquierda centro';
$string['lefttop'] = 'Izquierda Superior';
$string['like_item'] = 'Elemento LIKE';
$string['like_item_help'] = 'Hacer el área de detalles del mismo tamaño que la tarjeta.';
$string['loggedinuser'] = 'Usuario ingresado al sitio';
$string['loginstreakdays'] = 'Días de racha de ingresos';
$string['loginstreakdaysdesc'] = 'Configurar el número de días consecutivos requeridos para mantener una racha.';
$string['lowerthan'] = 'Menor que';
$string['maindashboard'] = 'Tablero principal';
$string['maintable'] = 'Seleccionar tabla principal <b>(mnt)</b>';
$string['maintable_help'] = 'Elegir la  tabla principal para generación de campo';
$string['maintablenotconfigured'] = 'Tabla principal NO configurada para el origen de datos de desarrollador';
$string['managecapabilitymissing'] = 'La capacidad requerida  "moodle/competency:competencymanage" para acceder a la página está faltando';
$string['managecompentency'] = 'Gestionar apariencia de competencias';
$string['managecustomdatasources'] = 'Gestionar orígenes de datos personalizados';
$string['managedashaddonplugins'] = 'Gestionar addons';
$string['managedashboards'] = 'Gestionar tableros';
$string['managedatasources'] = 'Gestionar orígenes de datos';
$string['managelayouts'] = 'Gestionar diseños';
$string['masonrycustomfield'] = 'Configuraciones de Dash';
$string['max'] = 'Máx';
$string['maxlimit'] = 'Limitar a';
$string['maxlimit_help'] = 'Limitar resultados de consulta a esta cantidad máxima.';
$string['mediumimage'] = 'Imagen mediana';
$string['menu'] = 'Orden del menú';
$string['messageurl'] = 'URL de mensaje';
$string['minheight'] = 'Altura mínima';
$string['minheight_help'] = 'Altura mínima en pixeles para bloque.';
$string['missingdatasource'] = 'Faltan los orígenes de datos. Por favor compruébelo.';
$string['missingmustachetemplate'] = 'Falta plantilla mustache.';
$string['mobile_learningpath'] = 'Ruta de Aprendizaje para Mobile';
$string['mobile_learningpath_desc'] = '';
$string['modifieddate'] = 'Fecha de última modificación';
$string['modulecontext'] = 'Módulo';
$string['modulename'] = 'Nombre del Módulo';
$string['mustachetemplate'] = 'Plantila Mustache';
$string['mydashboards'] = 'Mis tableros';
$string['myenrolledcourses'] = 'Mis cursos inscritos';
$string['myparticipants'] = 'Mis participantes / estudiantes';
$string['myprofiletable'] = 'Perfil';
$string['myskills'] = 'Mis habilidades';
$string['newblock'] = 'Nuevo Dash';
$string['nextlevelpoints'] = 'Puntos siguiente  nivel';
$string['nextlevelstr'] = '{$a->points} puntos  para volverse {$a->name}';
$string['nocampaignsareavailable'] = 'No hay campañas disponibles';
$string['nocategoryselected'] = 'Sin categoría seleccionada';
$string['nocontactsavailable'] = 'Sin contactos disponibles';
$string['nocourselearnigpath'] = 'Aun no se han añadido cursos a la ruta de aprendizaje.';
$string['nocourses'] = 'Sin cursos disponibles';
$string['nocourseselected'] = 'Sin curso seleccionado';
$string['nodashboardsforuser'] = 'Aun no hay tableros disponibles en este momento.';
$string['nogroupsavailable'] = 'Sin grupos disponibles';
$string['none'] = 'Ninguno';
$string['nonpublicdashboards'] = 'Ocultar tableros públicos';
$string['notachieved'] = 'No logrado';
$string['notauthorized'] = 'Usted no tiene acceso a este tablero.';
$string['notavailable'] = 'No disponible';
$string['oneormoreblocks'] = 'El tablero necesita más de un bloque.';
$string['onpagenavigation'] = 'En navegación de página';
$string['openmodule'] = 'Abrir módulo';
$string['operator'] = 'Operador';
$string['operatorcondition'] = 'Condición';
$string['operatorcondition_help'] = 'Operado conjuntivo - Elegir entre "AND" y "OR" para definir cómo son combinadas condiciones múltiples.
- "AND" requiere que todas las condiciones sean ciertas para que se cumpla la condición global.
- "OR" requiere que al menos una de las condiciones sea cierta para que se cumpla la condición global.';
$string['operatorequal'] = '=';
$string['operatorgreaterthan'] = '>';
$string['operatorgreaterthanequal'] = '>=';
$string['operatorlessthan'] = '<';
$string['operatorlessthanequal'] = '<=';
$string['operatornotequal'] = '!=';
$string['originalrolename'] = 'Nombre original';
$string['otheraddons'] = 'Otros addons';
$string['pagination_summary'] = 'Mostrando {$a->limit_from} - {$a->limit_to} de {$a->total}';
$string['parent'] = 'Padre';
$string['parseerror'] = 'Error de procesamiento. El contenido no puede ser mostrado.';
$string['participationnotcurrent'] = 'No actual';
$string['passed'] = 'Aprobado';
$string['permissions'] = 'Restringir acceso a';
$string['permissionscohort'] = 'Cohorte';
$string['permissionsloggedin'] = 'Debe estar ingresado en';
$string['permissionspublic'] = 'Público';
$string['permissionsrole'] = 'Rol';
$string['permissionsrolecontext'] = 'Contexto del rol';
$string['permissionsrolecontext_help'] = 'Seleccionar el contexto para el cual el rol del usuario debería ser checado (Cualquier rol o Solamente contexto del sistema)';
$string['perpage'] = 'Por página';
$string['perpage_help'] = 'Número de tarjetas a mostrar en rejilla por página.';
$string['persistenttablealias'] = 'Tabla principal de origen personalizado';
$string['pictureofuserlinked'] = 'Imagen del usuario (enlazada a perfil)';
$string['pictureofuserurl'] = 'URL de imagen del usuario';
$string['placeholderfields'] = 'Campos reemplazables';
$string['placeholderfields_help'] = 'Seleccionar los campos y usar esos campos en los valores personalizados adicionales de campo con {field_name}, esto será reemplazado con sus valores correspondientes.';
$string['pluginname'] = 'Dash';
$string['privacy:metadata'] = 'El bloque Dash solamente muestra información acerca de cursos y no almacena datos por si mismo.';
$string['proficient'] = 'Eficiente';
$string['programbg'] = 'Imagen Inscribir al programa';
$string['programbg_desc'] = '';
$string['programimagelink'] = 'Imagen de programa enlazada';
$string['programs:view'] = 'Ver programas';
$string['progress_help'] = 'Mostrar el progreso de finalización del curso.';
$string['promotionoptions'] = 'Destacado\\nNormal\\nAtenuado';
$string['querydebug'] = 'Depurar consulta';
$string['querytemplate'] = 'Plantilla de consulta';
$string['querytemplate_help'] = 'Esta consulta será usada para';
$string['querytemplateinstructions'] = 'Reemplazables: <ul><li><b>%%SELECT%%</b> - Reemplazados con todos los seleccionados basados en definiciones de campo. ¡NO incluya sus propios seleccionados!</li><li><b>%%WHERE%%</b> - Reemplazado con cláusulas generadas desde filtros. Usted puede añadir con seguridad más cláusulas al añadir  AND después de %%WHERE%%</li><li><b>%%GROUPBY%%</b> - Reemplazado con campo(s) de agrupamiento dependiendo del origen de datos</li><li><b>%%ORDERBY%%</b> - Reemplazado con ordenamiento predeterminado o con ordenamiento seleccionado por el usuario (por ejemplo, haciendo clic en el encabezado de columna en una tabla)</li></ul>';
$string['querytemplatetip'] = 'Sugerencia: Presione Ctrl + Espacio para mostrar intellisense / auto-completado cuando escriba su consulta.';
$string['readymatewidgets'] = 'Widgets listos para usarse';
$string['readymatewidgets_help'] = 'Use los widgets de abajo; los widgets son fáciles de usar; no hay necesidad de ajustar configuraciones adicionales.';
$string['recentcoursename'] = 'Curso reciente';
$string['redirecttodashboard'] = 'Redirigir al Tablero';
$string['relations'] = 'Relaciones';
$string['restrict_operator'] = 'Operador';
$string['restrictaccess'] = 'Restringir acceso';
$string['restrictaccessheading'] = 'Restringir acceso';
$string['restrictbyactivitycompletion'] = 'Restricción por estado de finalización de actividad';
$string['restrictbycohort'] = 'Restricción por cohorte';
$string['restrictbycoursecompletion'] = 'Restricción por etado de finalización del curso';
$string['restrictbygrade'] = 'Restricción por calificación del curso';
$string['restrictbygroup'] = 'Restricción por grupo de curso';
$string['restrictbyrole'] = 'Restricción por rol';
$string['restrictcurrentsection'] = 'Automáticamente restringir a sección actual';
$string['restrictcurrentsection_desc'] = 'Si un bloque Dash con el addon de contenido es añadido a una página de sección única, debería de estar automáticamente restringido a esa sección.';
$string['restrictrolecontext'] = 'Contexto';
$string['resumecourse'] = 'Reanudar curso';
$string['resumelearningpath'] = 'Reanudar ruta de aprendizaje';
$string['rightbottom'] = 'Derecha Fondo';
$string['rightcenter'] = 'Derecha Centro';
$string['righttop'] = 'Derecha Superior';
$string['role_assignments'] = 'Asignaciones de rol';
$string['rolename'] = 'Nombre del rol';
$string['rows'] = 'Filas';
$string['rows_help'] = 'Número de filas a mostrar cuando se usan múltiples filas con opción de páginasPorFila.';
$string['savechanges'] = 'Guardar cambios';
$string['secondarynav'] = 'Añadir a navegación del curso';
$string['selectactivity'] = 'Seleccionar actividad';
$string['selectcampaign'] = 'seleccionar campaña';
$string['selectcategory'] = 'seleccionar categoría';
$string['selectcourse'] = 'Seleccionar curso';
$string['selectlayout'] = 'Seleccionar el diseño del contenido en preferencias para añadir contenido.';
$string['selfallocationwithkey'] = 'Apuntarse (requiere clave)';
$string['setup'] = 'Configuración';
$string['shopurl'] = 'URL de la tienda';
$string['showheader'] = 'Mostrar encabezado';
$string['showheader_help'] = 'Ocultar el título del bloque si la edición está desactivada.';
$string['showhiddencourses'] = 'Mostrar cursos ocultos';
$string['skills'] = 'Habilidades';
$string['slidesPerRow'] = 'Páginas por fila';
$string['slidesPerRow_help'] = 'Número de páginas a mostrar en una fila.';
$string['slidesToScroll'] = 'Páginas a deslizar';
$string['slidesToScroll_help'] = 'Número de páginas a deslizar a la vez.';
$string['slidesToShow'] = 'Páginas a mostrar';
$string['slidesToShow_help'] = 'Número de páginas a mostrar a la vez.';
$string['smallimage'] = 'Imagen pequeña';
$string['smart_coursebutton'] = 'Botón de curso pequeño';
$string['sortalpha'] = 'Alfabéticamente';
$string['sortcoursestartdate'] = 'Fecha de inicio del curso';
$string['sortenrolmentdate'] = 'Fecha de inscripción';
$string['source'] = 'Origen';
$string['speed'] = 'Velocidad de transición (ms)';
$string['speed_help'] = 'Configurar la velocidad de transición de la página en milisegundos.';
$string['startcourse'] = 'Iniciar curso';
$string['stattodisplay'] = 'Figura a mostrar';
$string['stattodisplayother'] = 'Otra figura a mostrar';
$string['status'] = 'Estado';
$string['status:all'] = 'Todo';
$string['status:completed'] = 'Completado';
$string['status:enrolled'] = 'Inscrito';
$string['status:inprogress'] = 'En Progreso';
$string['status:notcompleted'] = 'No completado';
$string['status:notenrolled'] = 'No inscrito';
$string['status:notyetstarted'] = 'Aun no iniciado';
$string['strasc'] = 'Asc';
$string['strcssclass'] = 'Clase CSS';
$string['strctacampaign'] = 'Registro';
$string['strctaenrolment'] = 'Ver página de inscripción';
$string['strcustom'] = 'Personalizado';
$string['strcustomurl'] = 'Ver URL';
$string['strdatasource'] = 'datasource';
$string['strdesc'] = 'Desc';
$string['strdisabled'] = 'Deshabilitado';
$string['strexpanding'] = 'Expandiendo';
$string['strfloating'] = 'Flotando';
$string['strgrid'] = 'Rejilla';
$string['strgridsize'] = 'Tamaño de rejilla';
$string['strinfo'] = 'Info';
$string['strmasonry'] = 'Mampostería';
$string['strmasonrysearch'] = 'Caja de búsqueda';
$string['strmasonrysort'] = 'Ordenmiento';
$string['strmodal'] = 'Modal';
$string['strpromotion'] = 'Promoción';
$string['strrole'] = 'Rol';
$string['strshopurl'] = 'Ver tienda';
$string['strslider'] = 'Deslizador';
$string['styleoptions'] = 'Opciones de Estilo';
$string['styleoptions_help'] = 'Para poder aplicar estilos individuales a elementos, usted puede usar campos personalizados. elija los campos personalizados que deberían ser aplicados como clase CSS  al elemento rejilla. Nota: Usted tiene que crear los estilos CSS usted mismo. Dash no viene con estilos CSS predefinidos (pero pensamos añadirlos en la próxima versión).';
$string['subheadingfield'] = 'Campo de sub-encabezado';
$string['subheadingfieldicon'] = 'Ícono de sub-encabezado';
$string['suggestcohort'] = 'Sugerir usuarios que tienen el mismo cohorte';
$string['suggestcohort_desc'] = 'Mostrar el bloque con los usuarios con los mismos intereses de lista de contactos';
$string['suggestcontacts'] = 'Sugerir contactos';
$string['suggestgroups'] = 'Sugerir usuarios que tienen los mismos grupos';
$string['suggestgroups_desc'] = 'Mostrar el bloque con los usuarios con los mismos intereses de lista de contactos';
$string['suggestinterests'] = 'Sugerir usuarios que tienen los mismos intereses';
$string['suggestinterests_desc'] = 'Mostrar el bloque con los usuarios con los mismos intereses de lista de contactos';
$string['suggestion:cohort'] = 'También miembro de {$a->cohort}';
$string['suggestion:groups'] = 'En su grupo {$a->group}';
$string['suggestion:interest'] = 'También interesado en {$a->interest}';
$string['suggestion:users'] = 'Recomendado en este sitio';
$string['suggestusers'] = 'Sugerir usuarios que tienen los mismos usuarios';
$string['suggestusers_desc'] = 'Mostrar el bloque con los usuarios con los mismos intereses de lista de contactos';
$string['supportsfieldvisibility'] = 'Soporta visibilidad del campo';
$string['supportsfieldvisibility_help'] = 'Cuando se habilita, permitir al administrador habilitar y deshabilitar campos.';
$string['supportsfiltering'] = 'Soporta filtrado';
$string['supportsfiltering_help'] = 'Cuando se habilita, permite filtrar resultados. Esto es manejado por el origen de los datos.';
$string['supportspagination'] = 'Soporta paginación';
$string['supportspagination_help'] = 'Cuando se habilita, los resultados serán automáticamente paginados. La barra e paginación será mostrada.';
$string['supportssorting'] = 'Soporta ordenamiento';
$string['supportssorting_help'] = 'Cuando se habilita, el ordenamiento está permitido (solamente con tablas).';
$string['swipeToSlide'] = 'Deslizar a página';
$string['swipeToSlide_help'] = 'Habilita deslizar/arrastrar a página a la página más cercana después de soltar el toque.';
$string['system'] = 'Sistema';
$string['systemcontext'] = 'Sistema';
$string['tabconditions'] = 'Condiciones';
$string['tabfields'] = 'Campos';
$string['tabfilters'] = 'Filtros';
$string['tabgeneral'] = 'General';
$string['tablealias_c'] = 'Curso';
$string['tablealias_cc'] = 'Categoría de curso';
$string['tablealias_ccp'] = 'Finalización de curso';
$string['tablealias_ctx'] = 'Contexto';
$string['tablealias_dd'] = 'Tablero';
$string['tablealias_e'] = 'Método de inscripción';
$string['tablealias_g'] = 'Grupo';
$string['tablealias_r'] = 'Rol';
$string['tablealias_ra'] = 'Asignación de rol';
$string['tablealias_sl'] = 'Bitácoras del sitio';
$string['tablealias_tsk'] = 'Habilidades';
$string['tablealias_u'] = 'Usuario';
$string['tablealias_ue'] = 'Inscripción del usuario';
$string['tablejoin'] = 'Seleccionar tabla de unión';
$string['tablejoin_help'] = 'Elegir la tabla a unir con la tabla principal. Use alias para condiciones.';
$string['tablejoinon'] = 'Ingresar consulta de condición para unirse';
$string['tablejoinsalias'] = 'Alias de tabla';
$string['tablejoinshdr'] = 'Unir tablas';
$string['tablejoinstatichdr'] = 'Unir tabla #{$a}';
$string['tablet_learningpath'] = 'Ruta de Aprendizaje para Tableta';
$string['tablet_learningpath_desc'] = '';
$string['tags'] = 'Marcas';
$string['textcolor'] = 'Color del texto';
$string['timemodified'] = 'Hora de modificado';
$string['timesinceevent'] = 'Tiempo desde el evento';
$string['tinyimage'] = 'Imagen diminuta';
$string['titleoverride'] = 'Anulación del título';
$string['totalactivities'] = 'Total de actividades';
$string['totalactivitiescompletion'] = 'Total de actividades (relevantes para finalización)';
$string['totallevelpoints'] = 'Total de puntos del nivel';
$string['totalpoints'] = 'Puntos totales';
$string['totalprogress'] = 'Progreso total';
$string['transformformat'] = 'Transformar formato de {$a}';
$string['trialpath'] = 'Ensayo';
$string['usercontext'] = 'Usuario';
$string['userprofilelink'] = 'Enlace perfil del usuario';
$string['userprofileurl'] = 'URL perfil del usuario';
$string['users'] = 'Usuarios';
$string['users_help'] = 'Datasources de usuario muestra la lista de usuarios disponibles  del Sistema de Gestión del Aprendizaje';
$string['users_mycohort'] = 'Usuarios de una de mis cohortes';
$string['userscompleted'] = 'Usuarios completados';
$string['usersnotcompleted'] = 'Usuarios NO completados';
$string['userstat'] = 'Estadísticas usuario';
$string['variableWidth'] = 'Ancho variable';
$string['variableWidth_help'] = 'Habilitar páginas con ancho variable.';
$string['vertical'] = 'Vertical';
$string['verticalSwiping'] = 'Deslizado vertical';
$string['verticalSwiping_help'] = 'Habilitar deslizado /arrastrado vertical de páginas.';
$string['vertical_help'] = 'Orientación de página vertical';
$string['viewactivity'] = 'Ver actividad';
$string['viewcourse'] = 'Ver curso';
$string['viewdetails'] = 'Ver detalles';
$string['viewprofile'] = 'Ver perfil';
$string['viewprogram'] = 'Ver programa';
$string['widget'] = 'Widget';
$string['widget:course_completions'] = 'Finalizaciones de curso';
$string['widget:course_completions_help'] = 'Reporte de progreso de curso.';
$string['widget:course_enrols'] = 'Widget de Inscripciones';
$string['widget:course_enrols_help'] = 'Mostrar la lista de cursos inscritos con progreso de finalización';
$string['widget:course_sections'] = 'Secciones de curso';
$string['widget:groups:adduser'] = 'Añadir usuario';
$string['widget:groups:chat'] = 'Chat';
$string['widget:groups:creategroup'] = 'Crear Grupo';
$string['widget:groups:groupmembers'] = 'Ver Miembros';
$string['widget:groups:leavegroup'] = 'Abandonar Grupo';
$string['widget:learningpath'] = 'Ruta de Aprendizaje';
$string['widget:learningpath_help'] = 'Lista de cursos disponibles en la ruta de aprendizaje.';
$string['widget:mycontacts'] = 'Mis Contactos';
$string['widget:mycontacts_help'] = 'Lista de usuarios disponibles en la lista de contactos.';
$string['widget:mygroups'] = 'Mis grupos';
$string['widget:mygroups_help'] = 'Lista de grupos asignados para el usuario. Puede ver a otros miembros en el grupo, añadir miembros al grupo, abandonar los grupos y más';
$string['widget:mylearning'] = 'Mi aprendizaje';
$string['widget:mylearning_help'] = 'Lista de cursos inscritos del usuario con información básica del curso como por ejemplo staff y las insignias disponibles y las secciones y módulos del curso.';
$string['widget:myprofile'] = 'Mi perfil';
$string['widget:myprofile_help'] = 'Mostrar la información acerca del perfil del usuario con Indicadores Claves del desempeño importantes.';
$string['widget:skill_graph'] = 'Gráfica de habilidad';
$string['widget:skill_graph_help'] = 'Reporte desglosado de competencias';
$string['widget:skilllevelvisuals'] = 'Visuales de nivel de habilidad';
$string['widget:skilllevelvisuals_help'] = 'Mostrar los niveles asociados con habilidad seleccionada como imágenes.';
$string['widget:skillprogress'] = 'Progreso de habilidad';
$string['widget:skillprogress_help'] = 'EDl progeso de habilidad muestra el progreso global del usuario en todas las habilidades seleccionadas, incluyendo el nivel actual y los puntos ganados para cada habilidad individualmente.';
$string['widgetsdesc'] = 'Elegir un de contenido widget listo-para-usarse y configurarlo';
$string['withroles'] = 'Con rol(es)';
$string['yourcurrentlevel'] = 'Su nivel actual';
