<?php
// This file is part of Moodle - https://moodle.org/
//
// Moodle is free software: you can redistribute it and/or modify
// it under the terms of the GNU General Public License as published by
// the Free Software Foundation, either version 3 of the License, or
// (at your option) any later version.
//
// Moodle is distributed in the hope that it will be useful,
// but WITHOUT ANY WARRANTY; without even the implied warranty of
// MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE.  See the
// GNU General Public License for more details.
//
// You should have received a copy of the GNU General Public License
// along with Moodle.  If not, see <https://www.gnu.org/licenses/>.

/**
 * Strings for component 'theme_degrade', language 'es_mx', version '4.3'.
 *
 * @package     theme_degrade
 * @category    string
 * @copyright   1999 Martin Dougiamas and contributors
 * @license     https://www.gnu.org/copyleft/gpl.html GNU GPL v3 or later
 */

defined('MOODLE_INTERNAL') || die();

$string['access_course'] = 'Acceder al Curso';
$string['access_course_buy'] = 'Detalles del curso';
$string['acctoolbar_access_declaration'] = 'declaración de accesibilidad';
$string['acctoolbar_btn_bright'] = 'contraste<br>brillante';
$string['acctoolbar_btn_close'] = '✗ cerrar';
$string['acctoolbar_btn_cursor_black'] = 'cursor<br>negro grande';
$string['acctoolbar_btn_cursor_white'] = 'cursor<br>blanco grande';
$string['acctoolbar_btn_font_down'] = 'texto<br>reducido';
$string['acctoolbar_btn_font_readable'] = 'texto<br>legible';
$string['acctoolbar_btn_font_up'] = 'texto<br>agrandado';
$string['acctoolbar_btn_images_titles'] = 'títulos de<br>imágenes';
$string['acctoolbar_btn_invert'] = 'invertir<br>contraste';
$string['acctoolbar_btn_monochrome'] = 'visualización<br>incolora';
$string['acctoolbar_btn_open'] = 'Menú de accesibilidad';
$string['acctoolbar_btn_underline_headers'] = 'subrayar<br>encabezados';
$string['acctoolbar_btn_underline_links'] = 'subrayar<br>enlaces';
$string['acctoolbar_btn_zoom_in'] = 'zoom<br>pantalla';
$string['acctoolbar_content_block_header'] = 'resaltar contenido';
$string['acctoolbar_contrast_block_header'] = 'contraste de color';
$string['acctoolbar_debug_contacts'] = 'reportar un problema de accesibilidad';
$string['acctoolbar_disable_animattions'] = 'bloquear animaciones';
$string['acctoolbar_dyslexic'] = 'Font Legible para Dislexia';
$string['acctoolbar_image_without_alt'] = 'imagen sin texto';
$string['acctoolbar_keyboard_root'] = 'navegación por teclado';
$string['acctoolbar_reset_all_settings'] = 'reiniciar configuraciones';
$string['acctoolbar_text_block_header'] = 'tamaño del texto';
$string['acctoolbar_toolbar'] = 'Barra de herramientas de accesibilidad';
$string['acctoolbar_zoom_block_header'] = 'Zoom';
$string['add_block'] = '+ Agregar nuevo bloque';
$string['advancedsettings'] = 'Configuraciones avanzadas';
$string['background_color'] = 'Color del fondo';
$string['background_color_brasil'] = 'Brasil';
$string['background_color_default'] = 'Tema por defecto {$a}';
$string['background_color_desc'] = '¡Color de sprite!';
$string['background_course_image'] = 'Imagen predeterminada de fondo del curso';
$string['background_course_image_desc'] = 'Establecer una imagen de fondo predeterminada para el encabezado de todos los cursos. Esta imagen se mostrará en la parte superior de la página del curso y se puede reemplazar individualmente en la configuración del curso.';
$string['background_profile_image'] = 'Imagen del fondo del pefil';
$string['background_profile_image_desc'] = 'Imagen del fondo mostrada en el perfil del usuario.';
$string['background_text_color'] = 'Color del Texto';
$string['background_text_color_desc'] = '¡Color del Texto de Superior y Pie de página!';
$string['backgroundimage'] = 'Imagen de fondo';
$string['backgroundimage_desc'] = 'La imagen que se mostrará como fondo del sitio. La imagen de fondo que subas aquí reemplazará la imagen de fondo en los archivos preestablecidos de tu tema.';
$string['brandcolor'] = 'Color primario de la interfaz';
$string['brandcolor_angle'] = 'Ángulo del color de resaltado';
$string['brandcolor_angle_desc'] = 'Define el ángulo de rotación del degradado del fondo del menú.';
$string['brandcolor_background_menu'] = 'Aplicar el color de marca al fondo del menú';
$string['brandcolor_background_menu_desc'] = 'Esta configuración define si el color establecido en "Color de marca" se aplicará a los elementos del menú o al fondo del menú.<br>Si se aplica al fondo, el texto del menú se mostrará en blanco para asegurar un contraste adecuado.';
$string['brandcolor_desc'] = 'Configura el color de resaltado usando la selección anterior o eligiendo de la paleta a continuación.';
$string['brandcolor_gradient_1'] = 'Color primario del degradado';
$string['brandcolor_gradient_2'] = 'Color secundario del degradado';
$string['brandcolor_gradient_2_desc'] = 'Configura los colores primario y secundario del degradado usando el selector anterior o eligiendo de la paleta a continuación.';
$string['cachedef_course_cache'] = 'Caché de datos del curso';
$string['cachedef_course_module_cache'] = 'Caché de módulos del curso';
$string['cachedef_css_cache'] = 'Caché CSS';
$string['cachedef_darkmode_cache'] = 'Caché del Modo Oscuro';
$string['cachedef_data_cache'] = 'Caché de datos';
$string['cachedef_frontpage_cache'] = 'Caché de la página principal';
$string['cachedef_layout_cache'] = 'Caché de acomodo';
$string['cachedef_logo_cache'] = 'CAché de Logo';
$string['choosereadme'] = '';
$string['contact_address'] = 'Address';
$string['contact_email'] = 'Email';
$string['contact_phone'] = 'Phone Number';
$string['content_pagefonts'] = 'Fuentes Extra de Google';
$string['content_pagefonts_desc'] = 'Agrega aquí el enlace @import de Google para fuentes adicionales.<br>Puedes poner múltiples importaciones.<br><a href="https://fonts.google.com/selection/embed" target="google">Código de inserción</a><br><img src="{$a}" style="max-width: 100%;width: 420px;">';
$string['content_type_default'] = 'Moodle default';
$string['content_type_empty'] = '(No content)';
$string['content_type_footer'] = 'Content type for footer';
$string['content_type_footer_desc'] = 'Select the type of content you want to display in the footer.';
$string['content_type_home'] = 'Content type for homepage';
$string['content_type_home_desc'] = 'Select the type of content you want to display on the homepage.';
$string['content_type_html'] = 'Page to be created with editor';
$string['continuar'] = 'Continue studying';
$string['countlesson'] = '{$a} lesson';
$string['countlessons'] = '{$a} lessons';
$string['course_access'] = 'Acceder al curso';
$string['course_moore'] = 'Más detalles';
$string['course_summary'] = 'Mostrar el resumen del curso antes del Curso';
$string['course_summary_banner'] = 'Mostrar el resumen del curso antes del Curso';
$string['course_summary_banner_desc'] = 'Si está habilitado, el resumen del curso se mostrará antes del contenido principal del curso en la página del curso.';
$string['course_summary_banner_edit'] = 'Editar la imagen del banner de este curso';
$string['course_summary_banner_none'] = 'Sin encabezado';
$string['course_summary_banner_simple'] = 'Encabezado simple con información';
$string['course_summary_banner_title'] = 'Encabezado con banner';
$string['course_summary_desc'] = 'Si está habilitado, el resumen del curso se mostrará antes del contenido principal del curso en la página del curso.';
$string['courseindexoptions'] = 'Opciones del índice del curso';
$string['coursesettings'] = 'Curso';
$string['customcss_desc'] = 'Todas las reglas CSS que añada a esta área_de_texto se reflejarán en todas las páginas, haciendo más facil el personalizar este tema.';
$string['customfield_category_name'] = 'Personalización del tema';
$string['customfield_field_image'] = 'Imagen personalizada';
$string['customfield_field_image_desc'] = 'Seleccionar una imagen para personalizar el campo. La imagen será mostrada en el diseño y anulará las configuraciones globales del curso.';
$string['customfield_field_name'] = 'Mostrar imagen en la parte superior del Curso';
$string['customfield_field_name_desc'] = '<p>Este campo le permite elegir si muestra o no una imagen en la parte superior de la página del curso. Cuando se habilita, a imagen de su elección será mostrada de forma prominente, lo que reasalta el efecto vsual del curso y proporciona una experiencia más personalizada para usuarios.</p>';
$string['customfield_picture_missing'] = '<div class="alert alert-warning">Debes instalar el plugin <a href="https://moodle.org/plugins/customfield_picture" target="_blank">customfield_picture</a> para personalizar la imagen de fondo.</div>';
$string['custommenuitems'] = 'Elementos de menú personalizados';
$string['custommenuitems_desc'] = 'Puedes crear un menú personalizado junto a los menús superiores. El menú raíz debe comenzar al ras con el borde, y los submenús deben ir precedidos por un guión (-). El número de guiones determina la profundidad del elemento. Así, los elementos con un solo guión aparecen en un submenú debajo del elemento de nivel superior anterior, y los elementos con dos guiones aparecen en un submenú debajo del submenú anterior.
El contenido de cada elemento de menú debe consistir en hasta tres elementos (<strong>etiqueta</strong> | <strong>URL</strong> | <strong>tooltip</strong> | <strong>idioma</strong>), cada uno separado por el carácter "|".
<ul>
<li><strong>etiqueta</strong>: Este es el texto que se mostrará dentro del elemento de menú. Debes especificar una etiqueta para cada elemento de menú.</li>
<li><strong>URL</strong>: Esta es la URL a la que el usuario será llevado al hacer clic en el elemento de menú. Esto es opcional; si no se proporciona, el elemento no estará enlazado a ningún lugar.<br>
Se pueden agregar otros atributos como "target" al final de la URL.</li>
<li><strong>tooltip</strong>: Si proporcionas una URL, también puedes elegir proporcionar un tooltip para el enlace creado con la URL. Esto es opcional, y si no se define, se usará la etiqueta como tooltip para el elemento de menú.</li>
<li><strong>idioma</strong>: Puedes agregar un código de idioma (o una lista separada por comas de códigos) como el cuarto elemento de la línea. La línea se mostrará solo si el usuario ha seleccionado el/los idioma(s) listado(s).</li>
</ul>
A continuación, se muestra un ejemplo de cómo crear un menú personalizado:
<blockquote><pre>
Cursos
-Todos los cursos | /curso/
-Mis cursos
--Curso de ejemplo
---Curso de ejemplo 7 | /curso/ver.php?id=7
---Curso de ejemplo 9 | /curso/ver.php?id=9
--Curso de prueba
---Curso de prueba 2 | /curso/ver.php?id=2
---Curso de prueba 5 | /curso/ver.php?id=5
Google
-Google en cualquier idioma | https://google.com/" target="_blank
-Google en México | https://www.google.com.mx/" target="_blank|Etiqueta de Google|en
-Google en portugués | https://google.com.br/" target="_blank|Etiqueta de Google|pt,pt_br,pt_br_kids
Página de soporte | https://support.com/" target="_blank
</pre></blockquote>
Para Moodle con soporte para múltiples idiomas, el valor de <strong>etiqueta</strong> debe formatearse como <strong>"nombredelacadenaidioma,nombre del componente"</strong>.
<blockquote><pre>
perfil,moodle | /usuario/perfil.php
mensajes,mensaje | /mensaje/índice.php
</pre></blockquote>
<a href="https://docs.moodle.org/404/en/Configuración_avanzada_de_temas" target="_blank">Más información del menú</a>';
$string['delete_block_confirm'] = '¿Estás seguro de que deseas eliminar el bloque?';
$string['delete_block_success'] = 'Bloque eliminado con éxito';
$string['delete_block_title'] = 'Eliminar bloque';
$string['details-completaram'] = 'Curso completado';
$string['details-emprogresso'] = 'En progreso';
$string['details-not-access'] = 'Nunca accedido';
$string['details-teachers'] = 'Profesores';
$string['details-users'] = 'Estudiantes';
$string['edit_block'] = 'Editar bloque';
$string['editor_link_footer'] = 'Edit the footer block for {$a} language';
$string['editor_link_footer_all'] = 'Edit the footer block for all languages';
$string['editor_link_home'] = 'Edit the homepage for {$a} language';
$string['editor_link_home_all'] = 'Edit the homepage for all languages';
$string['error_invalidscss'] = 'SCSS no válido: {$ a}';
$string['favicon'] = 'Favicon.';
$string['favicon_desc'] = 'Cambiar el favicon del tema. Una imagen .png con fondo transparente y altura de 32 pixeles funcionará mejor.';
$string['fontfamily'] = 'Site Font';
$string['fontfamily_desc'] = 'Choose which font you want to use on your Moodle';
$string['fontfamily_menus'] = 'Fuentes del menú';
$string['fontfamily_menus_desc'] = 'Elige la fuente que deseas utilizar para los menús en tu sitio Moodle.';
$string['fontfamily_sitename'] = 'Fuente para el nombre del sitio';
$string['fontfamily_sitename_desc'] = 'La fuente que se aplicará al nombre del sitio si no se proporciona un logotipo.';
$string['fontfamily_title'] = 'Fuentes del texto del título';
$string['fontfamily_title_desc'] = 'Elige la fuente que deseas utilizar para los títulos en tu sitio Moodle.';
$string['fontpreview'] = 'Vista previa de lista de fuentes';
$string['footer_background_color'] = 'Color de fondo del pie de página';
$string['footer_background_color_desc'] = 'Selecciona el color de fondo para la sección del pie de página del sitio web. Déjalo en blanco para usar el color primario.';
$string['footer_contact_title'] = 'Contact Block Title';
$string['footer_contact_title_default'] = 'Contact us';
$string['footer_contact_title_desc'] = 'Enter the title of the block that will appear in the footer with the contact details.';
$string['footer_copywriter'] = 'Hecho con ❤️ por';
$string['footer_description'] = 'Description';
$string['footer_description_desc'] = 'Describe your Moodle, what you do, and this information will be shown below the logo in the Moodle footer';
$string['footer_frontpage_blockcourses_instructor'] = 'Show Professor\'s name';
$string['footer_frontpage_blockcourses_instructor_desc'] = 'If checked, shows the names of professors in the course list!';
$string['footer_frontpage_blockcourses_text'] = 'Short text explaining the "{$a}" block';
$string['footer_frontpage_blockcourses_text_desc'] = 'Add a text talking about "{$a}"!';
$string['footer_heading'] = 'Bloque {$a}';
$string['footer_heading_description_desc'] = '<ul>
  <li><strong>Sin bloques llenos:</strong> no se mostrará el pie de página.</li>
  <li><strong>1 bloque lleno:</strong> el contenido se mostrará como texto, sin formato de bloque.</li>
  <li><strong>2, 3 o 4 bloques llenos:</strong> el tema ajustará automáticamente el diseño para mostrar los bloques de manera responsiva y proporcional.</li>
</ul>
Completa solo los bloques que necesites, el tema se encargará del resto.';
$string['footer_heading_description_title'] = 'El tema se adapta automáticamente al número de bloques de pie de página que completes:';
$string['footer_html'] = 'Bloque de pie de página {$a} HTML';
$string['footer_html_desc'] = 'Agrega el código HTML personalizado que se mostrará en el bloque de pie de página {$a}.';
$string['footer_links_title'] = 'Links Block Title';
$string['footer_links_title_default'] = 'Important Links';
$string['footer_show_copywriter'] = 'Show Made with ❤️';
$string['footer_show_copywriter_desc'] = 'Uncheck if you want to hide the "Made with ❤️"';
$string['footer_social_title'] = 'Social Links Block Title';
$string['footer_social_title_default'] = 'Follow us on social media';
$string['footer_social_title_desc'] = 'Enter the title of the block that will appear in the footer with the data from your social networks.';
$string['footer_title'] = 'Título del bloque {$a}';
$string['footer_title_desc'] = 'Configura el título que aparecerá arriba del contenido HTML en el bloque de pie de página {$a}.';
$string['footerblink'] = 'Footer Block Links';
$string['footerblink_desc'] = 'You can configure a Footer Block Links here to be shown by themes.<br>Each line consists of some menu text or language key or text, a link URL (optional), separated by vertical bars. For example:<br><pre>Moodle Support|https://moodle.org/support</pre>';
$string['footerblock_contact'] = 'Contact block';
$string['footerblock_copywriter'] = 'Made with ❤️';
$string['footerblock_description'] = 'Description block';
$string['footerblock_links'] = 'Links block';
$string['footerblock_social'] = 'Social block';
$string['footersettings'] = 'Configuraciones del pie de página';
$string['free_name'] = 'Free';
$string['frontpage_about_description'] = 'Describe what you do';
$string['frontpage_about_description_desc'] = 'Describe in a maximum of 5 lines the purpose of your Moodle';
$string['frontpage_about_enable'] = 'Enable About block';
$string['frontpage_about_enable_desc'] = 'If checked, the About Block will appear below the Banner!';
$string['frontpage_about_info'] = 'Data box {$a}';
$string['frontpage_about_logo'] = 'Different logo to be shown here';
$string['frontpage_about_logo_desc'] = 'If set, this logo will be used here instead of the Top logo.<br>
Blank uses the Top Logo!';
$string['frontpage_about_number'] = 'Amount of data';
$string['frontpage_about_number_desc'] = 'Enter the amount of information mentioned above';
$string['frontpage_about_text'] = 'Data name';
$string['frontpage_about_text_1_defalt'] = 'Courses';
$string['frontpage_about_text_2_defalt'] = 'Teachers';
$string['frontpage_about_text_3_defalt'] = 'Students';
$string['frontpage_about_text_4_defalt'] = 'Lessons';
$string['frontpage_about_text_desc'] = 'Enter the name of the data to be shown on the home';
$string['frontpage_about_title'] = 'About block title';
$string['frontpage_about_title_default'] = 'Our Global Community';
$string['frontpage_add_block'] = 'Agregar nuevo bloque';
$string['frontpage_add_block_title'] = 'Seleccione el bloque de muestra para agregar';
$string['frontpage_change_editor'] = '¿Crear la página de inicio con el editor de Página?';
$string['frontpage_enable_editing'] = 'Habilitar edición para añadirle elementos a la página inicial';
$string['generalsettings'] = 'Configuraciones generales';
$string['heart'] = 'If you like this theme, don\'t forget to click ❤️ on the themes page <a href="{$a}" target="_blank">by clicking here</a>';
$string['homesettings'] = 'Configuraciones Iniciales';
$string['imageacceptedtypes'] = 'Solo están permitidos archivos de tipo {$a}';
$string['instructor'] = 'Instructor';
$string['language_all'] = 'Todos los idiomas disponibles';
$string['login_backgroundcolor'] = 'Background Color';
$string['login_backgroundcolor_desc'] = 'Select the background color of the password recovery page';
$string['login_backgroundfoto'] = 'Background Image';
$string['login_backgroundfoto_desc'] = 'Select the Login/Password Recovery/Create Account background image. Default image is: {$a}';
$string['login_forgot_description'] = 'Text on the side of the Forgot Password Screen';
$string['login_forgot_description_desc'] = 'Text that will appear only on the Forgot Password screen';
$string['login_login_description'] = 'Text on the side of the Login Screen';
$string['login_login_description_desc'] = 'Text that will appear only on the Login screen';
$string['login_signup_description'] = 'Text on the side of the Create an Account Screen';
$string['login_signup_description_desc'] = 'Text that will appear only on the Create an Account screen';
$string['login_theme'] = 'Login theme';
$string['login_theme_block'] = 'Central white block with optional background';
$string['login_theme_desc'] = 'Choose which theme you want in the Login area';
$string['login_theme_image_login'] = 'Background image and login on the side';
$string['login_theme_imagetext_login'] = 'Background image, text over the image, and login on the side';
$string['login_theme_login'] = 'Login screen only, no side image';
$string['loginbackgroundimage'] = 'Imagen del fondo de página para ingresar';
$string['loginbackgroundimage_desc'] = 'La imagen a mostrar como un fondo para la página para ingresar.';
$string['loginlogo'] = 'Logo PNG/SVG para la pantalla de inicio de sesión';
$string['loginlogo_desc'] = 'Suba el logo en formato PNG o SVG para que aparezca en la pantalla de inicio de sesión. El logo debe ser claro y representar la identidad visual de su institución o empresa, garantizando una experiencia de inicio de sesión profesional y consistente para los usuarios.';
$string['loginsettings'] = 'Configuraciones de Ingreso';
$string['logintheme'] = 'Tema del lienzo para Ingreso';
$string['logintheme_aurora'] = 'Aurora';
$string['logintheme_clean-minimal'] = 'Limpia Mínima';
$string['logintheme_clean-outline'] = 'Limpia Esquema';
$string['logintheme_dark-elegante'] = 'Oscura Elegante';
$string['logintheme_desc'] = 'Seleccione un tema visual que será mostrado en el lienzo para ingresar.';
$string['logintheme_selva-canopy'] = 'Dosel de Selva';
$string['logo_color'] = 'Colored Logo';
$string['logo_color_desc'] = 'Please upload your colored LOGO if you want to include it at the top. This logo will be displayed as the page is scrolled, and the menu will be displayed on a white background.';
$string['logo_write'] = 'White Logo';
$string['logo_write_desc'] = 'Please upload your white LOGO if you want to include it at the top. This logo will be displayed when scrolling remains at the top, and the menu will be displayed on a colored background.';
$string['matricular'] = 'Enroll';
$string['mycourses_color'] = 'Color de Fondo del Bloque';
$string['mycourses_color_desc'] = 'El color de fondo del bloque.';
$string['mycourses_icon'] = 'Icono';
$string['mycourses_icon_desc'] = 'Un icono representativo para el bloque. El tamaño del icono debe ser de 48x48 píxeles.';
$string['mycourses_info'] = 'Bloque {$a}';
$string['mycourses_numblocos'] = 'Sin bloques';
$string['mycourses_numblocos_desc'] = '¿Cuántas imágenes quieres en la Presentación de Diapositivas?';
$string['mycourses_numblocos_nenhum'] = 'Sin diapositivas en la página de inicio';
$string['mycourses_title'] = 'Título Corto del Bloque';
$string['mycourses_title_desc'] = 'Un título corto y descriptivo para el bloque.';
$string['mycourses_url'] = 'Enlace del Bloque';
$string['mycourses_url_desc'] = 'La URL a la que se navega al hacer clic en el bloque. Puede ser un enlace externo o un enlace interno dentro de la plataforma.';
$string['pluginname'] = 'Degrade Theme (Tema Degradado)';
$string['preview'] = 'Vista previa del bloque';
$string['privacy:drawerblockclosed'] = 'La preferencia actual para el cajón del bloque es cerrado.';
$string['privacy:drawerblockopen'] = 'La preferencia actual para el cajón de bloques está abierta.';
$string['privacy:drawerindexclosed'] = 'La preferencia actual para el cajón del índice es cerrado.';
$string['privacy:drawerindexopen'] = 'La preferencia actual para el cajón del índice es abierto.';
$string['privacy:metadata'] = 'The Degrade theme does not store any personal data about any user.';
$string['privacy:metadata:preference:draweropenblock'] = 'La preferencia del usuario para ocultar o mostrar el cajón con bloques.';
$string['privacy:metadata:preference:draweropenindex'] = 'La preferencia del usuario para ocultar o mostrar el cajón con el índice del curso.';
$string['privacy:metadata:preference:draweropennav'] = 'La preferencia del usuario para ocultar o mostrar el menú de navegación del cajón.';
$string['progress_percentage'] = 'Su progreso';
$string['quickstart_alert_notadd'] = 'No es posible cambiar el banner de la página inicial después de que se haya añadido. Para modificarlo, usted necesita ir a la  <a href="{$a}/">página inicial</a> y eliminar el banner existente.';
$string['quickstart_alert_notdelete'] = 'No es posible quitar los bloques añadidos aquí. Para eliminarlos , usted necesita ir a la  <a href="{$a}/">página inicial</a> y eliminar los bloques que ya no desee tener.';
$string['quickstart_banner-recreation-room'] = 'Sala de recreación';
$string['quickstart_banner-saved'] = 'La configuración se ha guardado correctamente.';
$string['quickstart_course_choose_below'] = 'O elige un banner abajo';
$string['quickstart_course_upload_or_choose'] = 'Sube una imagen o elige el tipo de banner que quieras';
$string['quickstart_home_pagebuilder'] = 'Inicio con Editor de Páginas';
$string['quickstart_home_pagebuilder_desc'] = 'Interfaz personalizable con secciones editables.';
$string['quickstart_home_selectsections'] = 'Selecciona las secciones deseadas:';
$string['quickstart_home_selectstyle'] = 'Elige el estilo de Inicio';
$string['quickstart_home_traditional'] = 'Inicio tradicional de Moodle';
$string['quickstart_home_traditional_desc'] = 'Página de inicio predeterminada de Moodle con bloques y cursos. Haz clic en el botón de abajo para editar la configuración del sistema.';
$string['quickstart_settings_link'] = '<div class="card mb-5">
<div class="card-header">Inicio rápido</div>
<div class="card-body"><a href="{$a}">Accede a la Guía de Inicio Rápido</a> y usa el configurador intuitivo para personalizar esta y otras configuraciones del tema Degrade.</div>
</div>';
$string['quickstart_title'] = 'Centro de configuración del tema';
$string['settings_about_heading'] = 'About your Moodle';
$string['settings_accessibility'] = 'Habilitar opciones de accesibilidad';
$string['settings_accessibility_desc'] = 'Permite la personalización de opciones para mejorar la accesibilidad de la plataforma, como el contraste, el tamaño de fuente y la navegación del teclado.';
$string['settings_accessibility_heading'] = 'Accesibilidad';
$string['settings_course_heading'] = 'Configuraciones del curso';
$string['settings_css_heading'] = 'Fuentes y CSS';
$string['settings_footer_heading'] = 'Footer Block';
$string['settings_icons_change_icons'] = 'Change the default icon in the course list';
$string['settings_icons_color_icon'] = 'Configurar un color personalizado para el ícono.';
$string['settings_icons_color_icon_desc'] = 'Seleccionar el color del fondo para el ícono mostrado en la lista de cursos. Dejar vacío para usar el color predeterminado del tema.';
$string['settings_icons_upload_icon'] = 'Subir el ícono personalizado.';
$string['settings_icons_upload_image'] = 'Imagen de bloque';
$string['settings_icons_upload_image_desc'] = 'Si se proporciona una imagen, el tema convertirá la fila del módulo en un bloque, usando la imagen como fondo. La imagen debe tener una relación de aspecto 16:9.';
$string['settings_login_heading'] = 'Login Screen';
$string['settings_mycourses_heading'] = 'Bloques de Mis Cursos';
$string['settings_slideshow_heading'] = 'SlideShow';
$string['settings_theme_heading'] = 'Theme and CSS';
$string['settings_top_heading'] = 'Top';
$string['showfooter'] = 'Mostrar pie de página';
$string['sitefonts'] = 'Fuentes adicionales de Google';
$string['sitefonts_desc'] = 'Inserta el código @import de Google Fonts como se indica en la imagen a continuación. Después de guardar, el campo "Fuente del sitio" se actualizará, mostrando estas fuentes. Puedes agregar múltiples @import según sea necesario.';
$string['slidecaption_desc'] = 'Enter the caption text to be used on the slide';
$string['slideshow_image'] = 'Slide Image';
$string['slideshow_image_desc'] = 'The image should be 1250px X 400px.';
$string['slideshow_info'] = 'Slide {$a}';
$string['slideshow_numslides'] = 'How many images in the SlideShow';
$string['slideshow_numslides_desc'] = 'How many images do you want in the SlideShow?';
$string['slideshow_numslides_nenhum'] = 'No slides on the Home';
$string['slideshow_text'] = 'Short descriptive text for the Slide';
$string['slideshow_text_desc'] = 'Insert a short text about the slide.';
$string['slideshow_url'] = 'Slides button link';
$string['slideshow_url_desc'] = 'Insert the destination link for the slide image button';
$string['social_facebook'] = 'Your Facebook';
$string['social_facebook_desc'] = 'Your organization\'s Facebook URL.';
$string['social_instagram'] = 'Your Instagram';
$string['social_instagram_desc'] = 'Your organization\'s Instagram URL.';
$string['social_linkedin'] = 'Your Linkedin';
$string['social_linkedin_desc'] = 'Your organization\'s Linkedin URL.';
$string['social_twitter'] = 'Your Twitter';
$string['social_twitter_desc'] = 'Your organization\'s Twitter URL.';
$string['social_youtube'] = 'Your Youtube';
$string['social_youtube_desc'] = 'Your organization\'s Youtube URL.';
$string['tableofcontents'] = 'Tabla de Contenidos';
$string['theme_color-color_buttons'] = 'Buttons Color';
$string['theme_color-color_buttons_desc'] = 'The color used for buttons, adding visual cohesion and emphasizing interactive actions.';
$string['theme_color-color_names'] = 'Names Color';
$string['theme_color-color_names_desc'] = 'Color used to highlight names or identifiers, providing clarity and emphasis on specific text information.';
$string['theme_color-color_primary'] = 'Primary Color';
$string['theme_color-color_primary_desc'] = 'The main primary color of the theme, usually used for highlight and emphasis elements.';
$string['theme_color-color_secondary'] = 'Secondary Color';
$string['theme_color-color_secondary_desc'] = 'A secondary color that complements the primary color, used to highlight secondary elements or to contrast with the primary color.';
$string['theme_color_desc'] = 'Select the colors of Moodle texts and buttons or click the line below:';
$string['theme_color_heading'] = 'Environment Color Selection';
$string['theme_color_sugestion'] = 'Sugerencia de color';
$string['theme_color_sugestion_text'] = 'Hacer clic en la línea para aplicar el color a los campos debajo:';
$string['theme_degrade_about_editbooton'] = 'Edit About block';
$string['theme_degrade_frontpage_bloco'] = 'Block "{$a}"';
$string['theme_degrade_frontpage_home'] = 'Home blocks';
$string['theme_degrade_mycourses_editbooton'] = 'Editar Bloques';
$string['theme_degrade_slideshow_editbooton'] = 'Edit SlideShow';
$string['theme_login_branco'] = 'Login screen only, no side image, with the form on a white background';
$string['top_color_heading'] = 'Scroll Top Color';
$string['top_scroll'] = 'Fijar el menú al desplazar la página';
$string['top_scroll_background_color'] = 'Background Color of Top Menu on Scroll';
$string['top_scroll_background_color_desc'] = 'Set the background color when scrolling the page.';
$string['top_scroll_desc'] = 'Cuando se habilita, el menú estará fijado a la parte superior de la pantalla mientras usted desplaza la página, asegurando acceso fácila las opciones del menú.';
$string['top_scroll_fix'] = 'Fijar el menú al desplazarse por la página';
$string['top_scroll_fix_desc'] = 'Cuando está habilitado, el menú se fijará en la parte superior de la pantalla mientras te desplazas por la página, asegurando fácil acceso a las opciones del menú.';
$string['top_scroll_text_color'] = 'Text Color of Menu on Scroll';
$string['top_scroll_text_color_desc'] = 'Set the text color of the menu when scrolling the page.';
$string['userprofilesettings'] = 'Perfil de usuario';
$string['vvveb_footer_contact_title_default'] = 'Contáctenos';
$string['vvveb_home_access'] = 'Acceder al curso';
$string['vvveb_home_automatically_catalogo'] = 'No editar. Este bloque será reemplazado automáticamente con el catálogo de cursos.';
$string['vvveb_home_automatically_category'] = 'No editar. Este bloque será reemplazado automáticamente con las categorías de cursos.';
$string['vvveb_home_automatically_my_course'] = 'No editar. Este bloque se reemplazará automáticamente con los cursos en los que el estudiante está inscrito.';
$string['vvveb_home_automatically_popular'] = 'No editar. Este bloque será reemplazado automáticamente con los cursos más populares.';
$string['vvveb_home_catalogo_heading'] = 'Catálogo de cursos';
$string['vvveb_home_category_heading'] = 'Categorías de cursos';
$string['vvveb_home_mycourses_heading'] = 'Mis Cursos';
$string['vvveb_home_popular_course'] = 'Cursos Populares';
$string['vvveb_home_team_subtitle'] = 'Somos un grupo de profesionales dedicados a su trabajo';
$string['vvveb_home_team_title'] = 'Conoce a Nuestro Equipo';
